#include "resource.h"
#include "glock3.hpp"
#include "bitmap6.hpp"

extern HWND hDlgView;
extern HWND main_hwnd;  //My main window, need for menu.
extern GosperClock *glock; //The object I'm editing with this dialog.
extern Frame main_frame;
extern WindowBitmap *wbm;
static void showparams(HWND hDlg); /* This is static to this module because
	I'll have	functions with the same names in other dialog code modules. */

BOOL CALLBACK ViewDialogProc( HWND hDlg, UINT message, WPARAM wParam,
	LPARAM lParam )
{ /* Note that this looks just like WndProc.  A modeless dialog
	proc must return TRUE when it processes a message and return
	FALSE for all other messages */

	wParam = (int)LOWORD(wParam); //Need to do this for 32 bit.
	switch (message)
	{ //Normally these are the only messages you need process.
		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(main_hwnd), IDM_VIEW,
				MF_BYCOMMAND | MF_CHECKED );
			showparams(hDlg);
			return TRUE;
		case WM_COMMAND:
			switch(wParam)
			{
				case VD_HAND:
				case VD_PIE:
				case VD_DISK:
					glock->SetHandshape(wParam);
					wbm->Clear(); //Clear the memory bitmap
					showparams(hDlg);
					break;
				case VD_ASPECT:
					main_frame.SetFixedAspect(TRUE ^ main_frame.GetFixedAspect());
					wbm->Clear(); //Clear the memory bitmap
					showparams(hDlg);
					break;
				case VD_ERASE:
					glock->SetWritemode(TRUE ^ glock->writemode());
					wbm->Clear(); //Clear the memory bitmap
					showparams(hDlg);
					break;
				default:
					break;
			}
			return TRUE;
		case WM_CLOSE: //This can be generated in various ways.
			DestroyWindow(hDlg);
			return TRUE;
		case WM_DESTROY: //
			CheckMenuItem( GetMenu(main_hwnd), IDM_VIEW,
				MF_BYCOMMAND | MF_UNCHECKED );
			hDlgView = NULL;
			InvalidateRect( main_hwnd, NULL, TRUE );
			return TRUE;
		default:
			return FALSE;
	}
}

static void showparams(HWND hDlg)
{//Display current values based on your glock accessors.

	CheckDlgButton( hDlg, VD_ASPECT,
		main_frame.GetFixedAspect()?MF_CHECKED:MF_UNCHECKED);
	CheckDlgButton( hDlg, VD_ERASE,
		glock->writemode()?MF_CHECKED:MF_UNCHECKED);
	CheckRadioButton(hDlg, VD_HAND, VD_DISK, glock->handshape()); 

}


